package sample_x5_nj_boot_gradle_jar_ko;

import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;
import software.amazon.awssdk.services.s3.presigner.model.PresignedGetObjectRequest;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;

public class AWSS3DownloadHelper {
	
	private final static String BUCKET_NAME = "";
	private final static String ACESSKEY_ID = "";
	private final static String SECRET_ACCESSKEY = "";
	//private final static String REGION = "";
	
	private S3Presigner presigner;
	
	AWSS3DownloadHelper() {
		this.presigner = S3Presigner.builder()
				.region(Region.AP_NORTHEAST_2)
				.credentialsProvider(StaticCredentialsProvider.create(AwsBasicCredentials.create(ACESSKEY_ID, SECRET_ACCESSKEY)))
				.build();
	}

	public Map<String, String> getPresignedURL(String key) {
		
		GetObjectRequest request = GetObjectRequest.builder()
				.bucket(BUCKET_NAME)
				.key(key)
				.build();	
		
		PresignedGetObjectRequest presignedRequest = presigner.presignGetObject(builder -> builder				 
				 .signatureDuration(Duration.ofMinutes(15))
				 .getObjectRequest(request));
		
		Map<String, String> map = new HashMap<>();
		map.put("url", presignedRequest.url().toString());
		 
		return map;
	}

}
