﻿using sample_x5_net5_en.helper;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace sample_x5_net5_en.service
{
    public class zip_download : IHttpHandler
    {

        public void ProcessRequest(HttpContext context)
        {
            Download(context);
        }

        public bool IsReusable
        {
            get
            {
                return false;
            }
        }

        private void Download(HttpContext context)
        {
            var key = context.Request.QueryString["key"] ?? string.Empty;
            var entry = FileRepository.Get(key);

            if (entry != null)
            {
                using (var dext = new DEXTUpload.NET.FileDownload())
                {
                    dext.Download(entry.Path, entry.FileName, new DEXTUpload.NET.DownloadOption
                    {
                        RemoveAfterDownloading = true,
                        UseClientCache = false,
                        MimeType = entry.MimeType
                    });
                }
            }
            else
            {
                throw new HttpException(404, "The zip file not found.");
            }
        }
    }
}