﻿using sample_x5_net5_en.helper;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;

namespace sample_x5_net5_en.service
{
    public class upload_service : IHttpHandler
    {

        public void ProcessRequest(HttpContext context)
        {
            Upload(context);
        }

        public bool IsReusable
        {
            get
            {
                return false;
            }
        }

        private void Upload(HttpContext context)
        {
            using (var dext = new DEXTUpload.NET.FileUpload())
            {
                var sb = new StringBuilder();
                var key = null as string;

                foreach (var element in dext.GetFileElements("DEXTUploadX5_FileData"))
                {
                    if (!element.IsEmpty)
                    {
                        element.Save();

                        key = FileRepository.Add(new FileEntity
                        {
                            FileName = element.FileName,
                            SavedFileName = element.LastSavedFileName,
                            MimeType = element.MimeType,
                            Size = element.OriginalFileLength,
                            SavedSize = element.FileLength,
                            Path = element.LastSavedFilePath
                        });

                        sb.AppendFormat("{0};", key);
                    }
                }

                context.Response.ContentType = "text/plain";
                context.Response.Write(sb.ToString());
            }
        }
    }
}