﻿namespace sample_x5_net5_en.service
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Web;
    using Azure.Storage;
    using Azure.Storage.Sas;

    public class get_upload_sastoken : IHttpHandler
    {
        const string ACCOUNT_NAME = "";
        const string CONTAINER_NAME = "";
        // Container's AccessKey
        const string ACCOUNT_KEY = "";

        public void ProcessRequest(HttpContext context)
        {
            context.Response.ContentType = "text/plain";

            try
            {
                var sasToken = GenerateContainerSasToken(ACCOUNT_NAME, ACCOUNT_KEY, CONTAINER_NAME);
                context.Response.Write(sasToken);
            }
            catch (Exception ex)
            {
                context.Response.StatusCode = 500;
                context.Response.Write(ex.ToString());
            }
        }

        public bool IsReusable
        {
            get
            {
                return false;
            }
        }

        private string GenerateContainerSasToken(string accountName, string accountKey, string containerName)
        {
            var credential = new StorageSharedKeyCredential(accountName, accountKey);
            var sasBuilder = new BlobSasBuilder
            {
                BlobContainerName = containerName,
                // Set the resource scope to container.
                Resource = "c",
                // Set the start time about 5 minutes earlier due to the time difference between servers.
                StartsOn = DateTimeOffset.UtcNow.AddMinutes(-5),
                // Valid for 1 hour
                ExpiresOn = DateTimeOffset.UtcNow.AddMinutes(60)
            };
            
            // The shared access token needs Create, Write permission to upload files.
            sasBuilder.SetPermissions(BlobAccountSasPermissions.Write | BlobAccountSasPermissions.Create);

            var sasToken = sasBuilder.ToSasQueryParameters(credential);

            return sasToken.ToString();
        }
    }
}