﻿namespace sample_x5_net5_en.service
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Web;
    using Azure.Storage;
    using Azure.Storage.Sas;

    public class get_list_sastoken : IHttpHandler
    {
        const string ACCOUNT_NAME = "";
        const string CONTAINER_NAME = "";
        // Container's AccessKey
        const string ACCOUNT_KEY = "";

        public void ProcessRequest(HttpContext context)
        {
            context.Response.ContentType = "text/plain";

            try
            {
                var blobName = context.Request.Form["key"] ?? "";
                // If sent with POST application/x-www-form-urlencoded encoding, the key is encoded and needs to be decoded.
                var sasToken = GenerateBlockListSasToken(ACCOUNT_NAME, ACCOUNT_KEY, CONTAINER_NAME, HttpUtility.UrlDecode(blobName).Replace("%20", "+"));
                context.Response.Write(sasToken);
            }
            catch (Exception ex)
            {
                context.Response.StatusCode = 500;
                context.Response.Write(ex.ToString());
            }
        }

        public bool IsReusable
        {
            get
            {
                return false;
            }
        }

        private string GenerateBlockListSasToken(string accountName, string accountKey, string containerName, string blobName)
        {
            var credential = new StorageSharedKeyCredential(accountName, accountKey);
            var sasBuilder = new BlobSasBuilder
            {
                BlobContainerName = containerName,
                // We need to create a shared access token with an unencoded name.
                BlobName = blobName,
                // Set the resource scope to Blob.
                Resource = "b",
                // Set the start time about 5 minutes earlier due to the time difference between servers.
                StartsOn = DateTimeOffset.UtcNow.AddMinutes(-5),
                // Valid for 1 hour
                ExpiresOn = DateTimeOffset.UtcNow.AddMinutes(60)
            };
            // The shared access token needs Read, List permission to read the list of uncommitted blocks.
            sasBuilder.SetPermissions(BlobAccountSasPermissions.Read | BlobAccountSasPermissions.List);

            var sasToken = sasBuilder.ToSasQueryParameters(credential);

            return sasToken.ToString();
        }
    }
}