﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Web;

namespace sample_x5_net5_en.service
{
    public class folder_upload : IHttpHandler
    {

        public void ProcessRequest(HttpContext context)
        {
            Upload(context);
        }

        public bool IsReusable
        {
            get
            {
                return false;
            }
        }

        private void Upload(HttpContext context)
        {
            using (var dext = new DEXTUpload.NET.FileUpload())
            {
                var sb = new StringBuilder();

                var files = dext.GetFileElements("DEXTUploadX5_FileData");
                var folders = dext.GetStringElements("DEXTUploadX5_Folder");
                var list = files.Zip(folders, (first, second) => new { File = first, Folder = second });
                var dir = null as DirectoryInfo;

                foreach (var pair in list)
                {
                    if (pair.Folder.IsFileElement == true)
                    {
                        dir = new DirectoryInfo(Path.Combine(dext.DefaultPath, pair.Folder.Value.Substring(1)));
                    }
                    else
                    {
                        dir = new DirectoryInfo(dext.DefaultPath);
                    }


                    if (!dir.Exists) dir.Create();

                    if (!pair.File.IsEmpty)
                    {
                        pair.File.Save(dir);
                        sb.AppendFormat("F:{0}\n", pair.File.LastSavedFilePath);
                    }
                }

                context.Response.ContentType = "text/plain";
                context.Response.Write(sb.ToString());
            }
        }
    }
}