﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace sample_x5_net5_en.helper
{
    public static class FileRepository
    {
        private static int _incrementableKey = 0;
        private static Dictionary<string, FileEntity> _repository = new Dictionary<string, FileEntity>();

        public static string Add(FileEntity entity)
        {
            lock (_repository)
            {
                var key = string.Format("F{0:00000}", ++_incrementableKey);
                entity.Key = key;
                _repository.Add(key, entity);
                return key;
            }
        }

        public static FileEntity Get(string key)
        {
            if (_repository.ContainsKey(key))
                return _repository[key];
            else
                return null;
        }

        public static IEnumerable<FileEntity> ToList()
        {
            return from p in _repository select p.Value;
        }

        public static IEnumerable<FileEntity> ToList(List<string> keys)
        {
            return (from p in keys select Get(p)).Where(c => c != null);
        }

        public static void Clear()
        {
            lock (_repository)
            {
                _repository.Clear();
                _incrementableKey = 0;
            }
        }
    }
}