﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace sample_x5_net5_en.helper
{
    public class DataEntity
    {
        public string Key { get; set; }
        public string Text { get; set; }
        public RadioOption Radio { get; set; }
        public bool Bird { get; set; }
        public bool Lion { get; set; }
        public bool Shark { get; set; }
        public SelectOption Selection { get; set; }
        public List<FileEntity> NewFiles { get; private set; }
        public List<string> OldFiles { get; private set; }
        public List<string> DeletedFiles { get; private set; }

        public DataEntity()
        {
            Text = string.Empty;
            Radio = RadioOption.None;
            Bird = false;
            Lion = false;
            Shark = false;
            Selection = SelectOption.None;
            NewFiles = new List<FileEntity>();
            OldFiles = new List<string>();
            DeletedFiles = new List<string>();
        }
    }

    public enum RadioOption
    {
        None,
        A,
        B
    }

    public enum SelectOption
    {
        None,
        Small,
        Big
    }
}