<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<meta http-equiv="X-UA-Compatible" content="IE=Edge" />
<link rel="stylesheet" type="text/css" href="./common/styles/default.css" />
<title>DEXTUploadX5 Spring Samples (with DEXTUploadNJ)</title>
</head>
<body>
	<header>
		<h1>Spring Examples</h1>
		<h3>for DEXTUploadX5</h3>
	</header>
	<div class="main">
		<section>
			<p>The sample project uses DEXTUploadNJ to process the files uploaded by DEXTUploadX5 on the server side and is based on JDK 1.8, Spring Framework 3.0.5 environment.</p>
			<p class="notice">The sample is based on the UTF-8 environment.</p>
			<p>
				The DEXTUploadNJ product is set up as an trial, so you do not have to set it up separately, and you can use it for 30 days. The "WEB-INF/dextuploadnj.config" file is an license(trial) file of the DEXTUploadNJ product. 
				Please refer to the DEXTUploadNJ product manual for more details.
			</p>
		</section>		
		<section>
			<h3>Basic examples</h3>
			<ul class="sample-list list-sub-2" id="tlb-basic">
				<li><p><span><a href="./multi/ex001.html">Example 01</a></span><span>Uploading a file with the simplest method</span></p></li>
				<li><p><span><a href="./multi/ex002.html">Example 02</a></span><span>Handling metadata</span></p></li>
				<li><p><span><a href="./multi/ex003.html">Example 03</a></span><span>Uploading by ORAF/OROF</span></p></li>
				<li><p><span><a href="./multi/ex004.html">Example 04</a></span><span>Downloading a file</span></p></li>
				<li><p><span><a href="./multi/ex005.html">Example 05</a></span><span>Opening a file</span></p></li>
				<li><p><span><a href="./multi/ex006.html">Example 06</a></span><span>Transferring files and form data</span></p></li>
				<li><p><span><a href="./multi/ex007.html">Example 07</a></span><span>Registering a new file with a post, deleting the existing files</span></p></li>
				<li><p><span><a href="./multi/ex008.html">Example 08</a></span><span>Hiding the progress window</span></p></li>
				<li><p><span><a href="./multi/ex009.html">Example 09</a></span><span>Changing the progress window</span></p></li>
				<li><p><span><a href="./multi/ex010.html">Example 10</a></span><span>Multiple components</span></p></li>
				<li><p><span><a href="./multi/ex011.html">Example 11</a></span><span>Using multiple components in a SINGLE style</span></p></li>
				<li><p><span><a href="./multi/ex012.html">Example 12</a></span><span>Compressing files and downloading</span></p></li>
				<li><p><span><a href="./multi/ex013.html">Example 13</a></span><span>Uploading as folder structure</span></p></li>
			</ul>
		</section>		
		<section>
			<h3>HD application</h3>
			<ul class="sample-list list-sub-2" id="tlb-hd">
				<li><p><span><a href="./hd/ex001.html">Example 01</a></span><span>Downloading multiple files</span></p></li>
				<li><p><span><a href="./hd/ex002.html">Example 02</a></span><span>Calling event address</span></p></li>
				<li><p><span><a href="./hd/ex003.html">Example 03</a></span><span>Changing options</span></p></li>
			</ul>
		</section>
		<section>
			<h3>Large file upload</h3>
			<ul class="sample-list list-sub-2" id="tlb-ext">
				<li><p><span><a href="./ext/ex001.html">Example 01</a></span><span>Uploading large files</span></p></li>
			</ul>
		</section>
		<section>
            <h3>Amazon S3</h3>
            <ul class="sample-list list-sub-2" id="tlb-awss3">
                <li><p><span><a href="./awss3/ex001.html">Example 01</a></span><span>Uploading files to Amazon S3</span></p></li>
                <li><p><span><a href="./awss3/ex002.html">Example 02</a></span><span>Uploading files to Amazon S3 (secured)</span></p></li>
                <li><p><span><a href="./awss3/ex003.html">Example 03</a></span><span>Downloading files from Amazon S3</span></p></li>
                <li><p><span><a href="./awss3/ex004.html">Example 04</a></span><span>Downloading files from Amazon S3 (secured)</span></p></li>
            </ul>
        </section>
        <section>
            <h3>NAVER CLOUD PLATFORM Object Storage</h3>
            <ul class="sample-list list-sub-2" id="tlb-ncpos">
                <li><p><span><a href="./ncpos/ex001.html">Example 01</a></span><span>Uploading files to NAVER CLOUD PLATFORM Object Storage</span></p></li>
                <li><p><span><a href="./ncpos/ex002.html">Example 02</a></span><span>Uploading files to NAVER CLOUD PLATFORM Object Storage (secured)</span></p></li>
                <li><p><span><a href="./ncpos/ex003.html">Example 03</a></span><span>Downloading files from NAVER CLOUD PLATFORM Object Storage</span></p></li>
                <li><p><span><a href="./ncpos/ex004.html">Example 04</a></span><span>Downloading files from NAVER CLOUD PLATFORM Object Storage (secured)</span></p></li>
            </ul>
        </section>
        <section>
            <h3>Microsoft Azure Blob Storage</h3>
            <ul class="sample-list list-sub-2" id="tlb-azrbs">
                <li><p><span><a href="./azrbs/ex001.html">Example 01</a></span><span>Uploading files to Microsoft Azure Blob Storage</span></p></li>
                <li><p><span><a href="./azrbs/ex002.html">Example 02</a></span><span>Downloading files from NMicrosoft Azure Blob Storage</span></p></li>
            </ul>
        </section>
	</div>
	<footer>
		<div>Copyright ⓒ DEXTSolution Inc. All rights reserved.</div>
	</footer>
</body>
</html>