package sample_x5_nj_spring_en;

import java.util.List;

import javax.servlet.http.HttpServletResponse;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SampleController {	
	
	@RequestMapping(value = "/service/form-process.do", method = RequestMethod.POST)
	public String formprocess(
			/* The DataEntity is a dummy VO class used for helping to show the result of uploading. */
			DataEntity data,
			@RequestParam(value = "newFileKeys", required = false) String newFileKeys,
			@RequestParam(value = "deleteFileKeys", required = false) String deleteFileKeys,
			HttpServletResponse response) {
		
		List<FileEntity> files = data.getFiles();
		
		String[] tokens = newFileKeys.split(";");
		for (String key : tokens) {
			if (key.isEmpty() == false) {
				files.add(FileRepository.getFileEntity(key));
			}
		}
		
		if (deleteFileKeys != null && deleteFileKeys.length() > 0) {
			data.setDeleteDescription(deleteFileKeys + " deleted.");
		} else {
			data.setDeleteDescription("No deleted files.");
		}
		
		// The DataRepository is a dummy class used for helping to show the result of uploading.
		String key = DataRepository.addDataEntity(data);
		
		if (deleteFileKeys != null) {
			// The process of deleting the physical file uploaded to the real server is safe at the end of every transaction.
		}
		
		return "redirect:/result/view-form.do?key=".concat(key);
	}
	
	@RequestMapping(value = "/result/view-form.do", method = RequestMethod.GET)
	public ModelAndView viewform(@RequestParam(value = "key") String key) {
		DataEntity data = DataRepository.getDataEntity(key);
		return new ModelAndView("/view-form", "data", data);
	}
	
}
