package sample_x5_nj_spring_en;

import java.io.IOException;

import javax.servlet.http.HttpServletResponse;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class AZRBSController {	
	
	@RequestMapping(value = "/service/get-list-sastoken.do", method = RequestMethod.POST)
	public void getListSasToken(
			@RequestParam(value = "key", required = false, defaultValue = "") String key,
			HttpServletResponse response) throws IOException {
		
		response.setCharacterEncoding("UTF-8");
		response.setContentType("text/plain");
		
		if (!key.isEmpty()) {
			AzureSasTokenGenerator gen = new AzureSasTokenGenerator();
			String token = gen.generateBlobListSasToken(key);
			response.getWriter().write(token);
		} else {		
			response.setStatus(400);
			response.getWriter().write("Invalid parameters");
		}
	}
	
	@RequestMapping(value = "/service/get-upload-sastoken.do", method = RequestMethod.GET)
	public void getUploadSasToken(HttpServletResponse response) throws IOException {
		
		response.setCharacterEncoding("UTF-8");
		response.setContentType("text/plain");
		
		AzureSasTokenGenerator gen = new AzureSasTokenGenerator();
		String token = gen.generateContainerSasToken();
		response.getWriter().write(token);
	}
	
	@RequestMapping(value = "/service/get-download-sastoken.do", method = RequestMethod.POST)
	public void getDownloadSasToken(
			@RequestParam(value = "key", required = false, defaultValue = "") String key,
			HttpServletResponse response) throws IOException {
		
		response.setCharacterEncoding("UTF-8");
		response.setContentType("text/plain");
		
		if (!key.isEmpty()) {
			AzureSasTokenGenerator gen = new AzureSasTokenGenerator();
			String token = gen.generateBlobSasToken(key);
			response.getWriter().write(token);
		} else {		
			response.setStatus(400);
			response.getWriter().write("Invalid parameters");
		}
	}
	
}
