package sample_x5_nj_servlet_ko;

import java.io.File;
import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import devpia.dextuploadnj.FileItem;
import devpia.dextuploadnj.support.common.FileUpload;

@SuppressWarnings("serial")
public class ExtensionUpload extends HttpServlet {
	
    public ExtensionUpload() {
        super();
    }

    @Override
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

    	FileUpload dextnj = null;
		String key = "";
		
		try {
			
			dextnj = new FileUpload(request);
			
			dextnj.prepare();
			
			FileItem item = dextnj.getFileItem();
				
			if (!item.isEmpty()) {
				// 대상이 올바른 파일이라면 실제 저장할 위치로 임시 파일을 저장(복사 혹은 이동)한다.
				// 인자로 주어진 디렉터리 경로가 없다면 extensionUploadFilter 필터의 defaultRepository 파라미터 값으로 설정된 경로로 설정된다.
				item.save();
				
				FileEntity file = new FileEntity();
				file.setFieldName(item.getFieldName());
				file.setFilename(item.getFilename());
				file.setMime(item.getContentType());
				file.setSize(item.getFileSize());
				file.setFile(new File(item.getLastSavedFilePath()));
				
				// 파일 정보를 DB에 등록했다고 가정하고 키값을 반환한다.
				key = FileRepository.addFileEntity(file);
			} else {
				// 파일 정보가 없다면 문제가 있는 것이므로 오류 처리를 해야 한다.
			}
			
			// 응답 데이터를 작성한다.
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/plain");
			// 파일의 키를 응답 데이터로 작성한다.
			response.getWriter().write(key);
			
		} finally {
			// 리소스를 제거한다. 삭제가 되지 않은 임시 파일이 있다면 모두 삭제된다.
			if (dextnj != null) dextnj.close();
		}
	}
}
