package sample_x5_jk_boot_gradle_jar_ko;

import java.util.List;

import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.AbstractMultipartHttpServletRequest;

public class DEXTUploadX5ListArgumentResolver implements HandlerMethodArgumentResolver {

	@Override
	public boolean supportsParameter(MethodParameter parameter) {
		return parameter.getParameterType() == DEXTUploadX5List.class;
	}

	@Override
	public Object resolveArgument(
			MethodParameter parameter, 
			ModelAndViewContainer mavContainer, 
			NativeWebRequest webRequest, 
			WebDataBinderFactory binderFactory) throws Exception {
		
		AbstractMultipartHttpServletRequest multipartRequest = webRequest.getNativeRequest(AbstractMultipartHttpServletRequest.class);
		DEXTUploadX5List list = new DEXTUploadX5List();
		DEXTUploadX5Item item = null;
		
		String[] controlIds = multipartRequest.getParameterValues("DEXTUploadX5_ControlId");
		String[] uniqueIds = multipartRequest.getParameterValues("DEXTUploadX5_UniqueId");
		String[] folders = multipartRequest.getParameterValues("DEXTUploadX5_Folder");
		String[] metadatas = multipartRequest.getParameterValues("DEXTUploadX5_MetaData");
		String[] exifs = multipartRequest.getParameterValues("DEXTUploadX5_EXIFData");
		List<MultipartFile> files = multipartRequest.getFiles("DEXTUploadX5_FileData"); 
		
		for (int i = 0; i < files.size(); i++) {
			item = new DEXTUploadX5Item();
			item.setControlId(controlIds[i]);
			item.setUniqueId(uniqueIds[i]);
			item.setFolder(folders[i]);
			item.setMetaData(metadatas[i]);
			item.setEXIFData(exifs[i]);
			item.setFileData(files.get(i));
			list.add(item);
		}
		
		return list;
	}

}
