package sample_x5_jk_boot_gradle_jar_ko;

import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.multipart.support.AbstractMultipartHttpServletRequest;

public class DEXTUploadX5ItemArgumentResolver implements HandlerMethodArgumentResolver {

	@Override
	public boolean supportsParameter(MethodParameter parameter) {
		return parameter.getParameterType() == DEXTUploadX5Item.class;
	}

	@Override
	public Object resolveArgument(
			MethodParameter parameter, 
			ModelAndViewContainer mavContainer, 
			NativeWebRequest webRequest, 
			WebDataBinderFactory binderFactory) throws Exception {

		DEXTUploadX5Item file = new DEXTUploadX5Item();
		AbstractMultipartHttpServletRequest multipartRequest = webRequest.getNativeRequest(AbstractMultipartHttpServletRequest.class);
		file.setControlId(multipartRequest.getParameter("DEXTUploadX5_ControlId"));
		file.setUniqueId(multipartRequest.getParameter("DEXTUploadX5_UniqueId"));
		file.setFolder(multipartRequest.getParameter("DEXTUploadX5_Folder"));
		file.setMetaData(multipartRequest.getParameter("DEXTUploadX5_MetaData"));
		file.setEXIFData(multipartRequest.getParameter("DEXTUploadX5_EXIFData"));
		file.setFileData(multipartRequest.getFile("DEXTUploadX5_FileData"));

		return file;

	}

}
