package sample_x5_nj_servlet_ja;

import java.io.File;
import java.io.IOException;
import java.util.List;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import devpia.dextuploadnj.Environment;
import devpia.dextuploadnj.FileItem;
import devpia.dextuploadnj.support.common.FileUpload;

@SuppressWarnings("serial")
public class UploadService extends HttpServlet {
	
	private Environment env;
       
    public UploadService() {
        super();
    }

	public void init(ServletConfig config) throws ServletException {
		super.init(config);
		
		String temporaryDirPath = null;
		String repositoryDirPath = null;
		String licenseFilePath = null;		
		
		try {
			File rootDir = new File(config.getServletContext().getRealPath("/"));
			temporaryDirPath = new File(rootDir, "files/temp/").getCanonicalPath();
			repositoryDirPath = new File(rootDir, "files/store/").getCanonicalPath();	
			licenseFilePath = new File(rootDir, "WEB-INF/dextuploadnj.config").getCanonicalPath();			
		} catch (IOException e) {
			throw new ServletException(e.getMessage());
		}		
		
		env = new Environment();
		env.setCharEncoding("UTF-8");
		env.setTempRepository(temporaryDirPath);
		env.setDefaultRepository(repositoryDirPath);
		env.setAutoMakingDirectory(true);
		env.setLicenseFilePath(licenseFilePath);
	}

	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		FileUpload dextnj = null;
		
		try {
			dextnj = new FileUpload(request, env);
			
			dextnj.prepare();
			
			List<FileItem> items = dextnj.getFileItems();
			
			StringBuffer sb = new StringBuffer();

			for (FileItem next : items) {
				if (next.isEmpty() == false) {
					next.save();
					
					FileEntity file = new FileEntity();
					file.setFieldName(next.getFieldName());
					file.setFilename(next.getFilename());
					file.setMime(next.getContentType());
					file.setSize(next.getFileSize());
					file.setFile(new File(next.getLastSavedFilePath()));
					
					String key = FileRepository.addFileEntity(file);
					
					sb.append(String.format("%1$s;", key));
				}
			}
			
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/plain");
			response.getWriter().write(sb.toString());
			
		} catch (Exception e) {
			throw new ServletException(e);
		} finally {
			if (dextnj != null) dextnj.close();
		}
	}
}
