package sample_x5_nj_servlet_ja;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import software.amazon.awssdk.services.s3.model.CompletedPart;

@SuppressWarnings("serial")
public class NCPOSUpload extends HttpServlet {

    public NCPOSUpload() {
        super();
    }

	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		
		request.setCharacterEncoding("UTF-8");
		response.setCharacterEncoding("UTF-8");
		response.setContentType("application/json");
		
		String step = request.getParameter("step");
		
		try {
			switch (step) {
			case "0": processStepZero(request, response); break;
			case "1": processStepOne(request, response); break;
			case "2": processStepTwo(request, response); break;
			case "3": processStepThree(request, response); break;
			default:
				response.setStatus(400);
				response.getWriter().write(String.format("{ \"error\": \"'%s' is an unknown step.\" }", step));
				break;
			}
		} catch (Exception ex) {
			response.setStatus(500);
			response.getWriter().write(String.format("{ \"error\": \"%s\" }", ex.getMessage()));
		}
	}
	
	private <A, B, C> Stream<C> zip(Stream<A> s1, Stream<B> s2, BiFunction<A, B, C> combiner) {
		Iterator<A> i1 = s1.iterator();
		Iterator<B> i2 = s2.iterator();
		Iterator<C> zippedIterator = new Iterator<C>() {
			@Override
			public boolean hasNext() {
				return i1.hasNext() && i2.hasNext();
			}
			@Override
			public C next() {
				return combiner.apply(i1.next(), i2.next());
			}
		};
		Spliterator<C> spliterator = Spliterators.spliteratorUnknownSize(zippedIterator, Spliterator.ORDERED);
		return StreamSupport.stream(spliterator, false);
	}
	
	private void processStepZero(HttpServletRequest req, HttpServletResponse res) throws IOException, URISyntaxException {
		String key = Optional.ofNullable(req.getParameter("key")).orElse("");
		String acl = Optional.ofNullable(req.getParameter("acl")).orElse("private");
		String sclass = Optional.ofNullable(req.getParameter("sclass")).orElse("STANDARD");
		String type = Optional.ofNullable(req.getParameter("type")).orElse("application/octet-stream");
		String meta = Optional.ofNullable(req.getParameter("metadata")).orElse("");

		if (!key.isEmpty() && !type.isEmpty()) {
			NCPOSMultipartUploadHelper helper = new NCPOSMultipartUploadHelper();
			res.getWriter().write(helper.initializeUpload(key, sclass, acl, type, meta));
		} else {		
			res.setStatus(400);
			res.getWriter().write("{ \"error\": \"Invalid parameters.\" }");
		}
	}
	
	private void processStepOne(HttpServletRequest req, HttpServletResponse res) throws IOException, URISyntaxException {
		String key = Optional.ofNullable(req.getParameter("key")).orElse("");
		String uid = Optional.ofNullable(req.getParameter("uid")).orElse("");
		String pnum = Optional.ofNullable(req.getParameter("pnum")).orElse("");
		
		if (!key.isEmpty() && !uid.isEmpty() && !pnum.isEmpty()) {
			int pi = Integer.parseInt(pnum);
			NCPOSMultipartUploadHelper helper = new NCPOSMultipartUploadHelper();
			res.getWriter().write(helper.getPresignedURL(key, uid, pi));
		} else {		
			res.setStatus(400);
			res.getWriter().write("{ \"error\": \"Invalid parameters.\" }");
		}
	}
	
	private void processStepTwo(HttpServletRequest req, HttpServletResponse res) throws IOException, URISyntaxException {
		String key = Optional.ofNullable(req.getParameter("key")).orElse("");
		String uid = Optional.ofNullable(req.getParameter("uid")).orElse("");
		String[] pnums = Optional.ofNullable(req.getParameterValues("pnum")).orElse(new String[] {});
		String[] etags = Optional.ofNullable(req.getParameterValues("etag")).orElse(new String[] {});
		
		Stream<CompletedPart> zipped = zip(
				Stream.of(pnums).map(v -> Integer.parseInt(v)),
				Stream.of(etags),
				(v1, v2) -> CompletedPart.builder().partNumber(v1).eTag(v2).build());
		
		List<CompletedPart> parts = zipped.collect(Collectors.toList());
		
		if (!key.isEmpty() && !uid.isEmpty() && parts.size() > 0) {
			NCPOSMultipartUploadHelper helper = new NCPOSMultipartUploadHelper();
			res.getWriter().write(helper.completeUpload(key, uid, parts));
		} else {		
			res.setStatus(400);
			res.getWriter().write("{ \"error\": \"Invalid parameters.\" }");
		}
	}
	
	private void processStepThree(HttpServletRequest req, HttpServletResponse res) throws IOException, URISyntaxException {
		String key = Optional.ofNullable(req.getParameter("key")).orElse("");
		String uid = Optional.ofNullable(req.getParameter("uid")).orElse("");
		
		if (!key.isEmpty() && !uid.isEmpty()) {
			NCPOSMultipartUploadHelper helper = new NCPOSMultipartUploadHelper();
			helper.abortUpload(key, uid);
		} else {		
			res.setStatus(400);
			res.getWriter().write("{ \"error\": \"Invalid parameters.\" }");
		}
	}

}
