package sample_x5_nj_servlet_ja;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FileRepository {

	private static int incrementableKey = 0;
	private static final Map<String, FileEntity> repository = new HashMap<String, FileEntity>();
	
	public static synchronized String addFileEntity(FileEntity entity) {		
		String key = String.format("F%1$05d", ++incrementableKey);
		repository.put(key, entity);
		entity.setKey(key);
		return key;
	}
	
	public static FileEntity getFileEntity(String key) {		
		if (repository.containsKey(key))
			return repository.get(key);
		else
			return null;
	}
	
	public static List<FileEntity> getFileEntities() {		
		Set<String> keys = repository.keySet();
		return getFileEntities(Utils.toList(keys.toArray(new String[keys.size()])));
	}
	
	public static List<FileEntity> getFileEntities(List<String> keys) {		
		List<FileEntity> list = new ArrayList<FileEntity>();
		Iterator<String> iterator = keys.iterator();
		FileEntity temp = null;
		while (iterator.hasNext()) {
			temp = getFileEntity(iterator.next());
			if (temp != null) list.add(temp);
		}
		return list;		
	}
	
	public static synchronized void clear() {		
		repository.clear();
		incrementableKey = 0;
	}
}
