package sample_x5_nj_servlet_ja;

import java.io.File;
import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import devpia.dextuploadnj.FileItem;
import devpia.dextuploadnj.support.common.FileUpload;

@SuppressWarnings("serial")
public class ExtensionUpload extends HttpServlet {
	
    public ExtensionUpload() {
        super();
    }
    
    @Override
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		FileUpload dextnj = null;
		String key = "";
		
		try {
			// HTTPリクエストオブジェクトを受け取るFileUploadオブジェクトを作成する。
			dextnj = new FileUpload(request);
			
			dextnj.prepare();
			
			// FileUpload#getFileItemメソッドを使用して、アップロードされたファイル情報を取得できます。
			FileItem item = dextnj.getFileItem();
			
			if (!item.isEmpty()) {
				// 引数にディレクトリパスが与えられていない場合は、extensionUploadFilterフィルタのdefaultRepositoryパラメータ値で設定されたパスが対象となります。 
				item.save();
				
				FileEntity file = new FileEntity();
				file.setFieldName(item.getFieldName());
				file.setFilename(item.getFilename());
				file.setMime(item.getContentType());
				file.setSize(item.getFileSize());
				file.setFile(new File(item.getLastSavedFilePath()));
				
				key = FileRepository.addFileEntity(file);
			} else {
				// ファイルがない場合は、エラーを発生させる必要があります。
				// 例外を処理したくない場合は、"response.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR); "を使用して、HTTPステータスコードをエラーとして送信する必要があります。
			}
			
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/plain");
			response.getWriter().write(key);
			
		} finally {
			// リソースを削除する。
			// 削除されていない一時ファイルをすべて削除する。
			if (dextnj != null) dextnj.close();
		}
	}
}
