package sample_x5_nj_servlet_ja;

import java.io.File;
import java.io.IOException;
import java.util.List;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import devpia.dextuploadnj.Environment;
import devpia.dextuploadnj.FileItem;
import devpia.dextuploadnj.support.common.FileUpload;

@SuppressWarnings("serial")
public class CommonUpload extends HttpServlet {

	private Environment env;
       
    public CommonUpload() {
        super();
    }

	public void init(ServletConfig config) throws ServletException {
		super.init(config);
		
		String temporaryDirPath = null;
		String repositoryDirPath = null;
		String licenseFilePath = null;		
		
		try {
			File rootDir = new File(config.getServletContext().getRealPath("/"));
			temporaryDirPath = new File(rootDir, "files/temp/").getCanonicalPath();
			repositoryDirPath = new File(rootDir, "files/store/").getCanonicalPath();
			// Set to the license file path for the DEXTUploadNJ.
			licenseFilePath = new File(rootDir, "WEB-INF/dextuploadnj.config").getCanonicalPath();
			
		} catch (IOException e) {
			throw new ServletException(e.getMessage());
		}		
		
		env = new Environment();
		
		// テンポラリディレクトリのパス、デフォルトディレクトリのパスなどを設定します。
		env.setCharEncoding("UTF-8");
		env.setTempRepository(temporaryDirPath);
		env.setDefaultRepository(repositoryDirPath);
		env.setAutoMakingDirectory(true);
		env.setLicenseFilePath(licenseFilePath);
	}

	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		FileUpload dextnj = null;
		
		try {
			// HTTPリクエストオブジェクトと設定オブジェクトを引数として受け取るFileUploadオブジェクトを作成します。 
			dextnj = new FileUpload(request, env);
			
			// クライアントからのファイルデータ部分をすべて一時ファイルとして保存する。
			// 一時保存場所はEnvironment#setTempRepositoryメソッドで設定します。
			dextnj.prepare();
			
			// FileUpload#getFileItemメソッドでフォーム名で呼び出すこともできますが、getFileItemsメソッドでコレクションオブジェクトを取得します。
			List<FileItem> items = dextnj.getFileItems();
			
			// 応答データを書き込むためのバッファ。
			StringBuffer sb = new StringBuffer();	
			
			FileItem file = null;
			for (int i = 0; i < items.size(); i++) {
				
				file = items.get(i);
				
				if (file.isEmpty() == false) {
					// アイテムが正しいファイルであれば、一時的な場所からターゲットにファイルを保存（コピーまたは移動）します。
					// 引数として与えられたディレクトリパスがない場合、ターゲットは Environment#setDefaultRepository メソッドで設定されたパスになります。
					file.save();
					
					// 保存されたファイルの場所をレスポンスデータバッファに書き込む。
					sb.append(String.format("F:%1$s\n", file.getFilename()));
				}
			}
			
			// レスポンスデータの作成。
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/plain");
			response.getWriter().write(sb.toString());
			
		} catch (Exception e) {
			// 問題が発生した場合は、エラーを発生させる必要があります。
			// 例外を処理したくない場合は、"response.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR); "を使用して、HTTPステータスコードをエラーとして送信する必要があります。
			throw new ServletException(e);
		} finally {
			// リソースを削除します。
			// 削除されていないすべての一時ファイルを削除します。
			if (dextnj != null) dextnj.close();
		}
	}
}
