package sample_x5_nj_servlet_ja;

import java.io.File;
import java.io.IOException;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import devpia.dextuploadnj.support.common.FileDownload;

@SuppressWarnings("serial")
public class CommonDownload extends HttpServlet {
	
	private String fileRoot;
       
    public CommonDownload() {
        super();
    }
    
	public void init(ServletConfig config) throws ServletException {
		super.init(config);
		
		fileRoot = config.getServletContext().getRealPath("/files/attach/");
	}
	
	protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		this.doGet(request, response);
	}

	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		
		File target = null;
		
		String key = request.getParameter("key");
		
		if (key.equals("FID0001")) target = new File(fileRoot, "bridge_509147.jpg");
		else if (key.equals("FID0002")) target = new File(fileRoot, "beach_239826.jpg");
		else if (key.equals("FID0003")) target = new File(fileRoot, "cosmos (empty) 195779.jpg");
		
		if (target == null  || target.exists() == false || target.isFile() == false) {
			response.sendError(HttpServletResponse.SC_NOT_FOUND, "キーに対応するファイルが見つかりません。");
			return;
		}
		
		try {
			
			// FileDownload オブジェクトを作成します。
			FileDownload dextnj = new FileDownload();
			
			// UTF-8 に設定します。
			response.setCharacterEncoding("UTF-8");
			
			// HDアプリケーションを使用する場合、"DEXTUploadX5 "で始まるUser-Agentを取得することができます。
			if (request.getHeader("User-Agent").indexOf("DEXTUploadX5") >= 0) {
				dextnj.setAllowingWeakRange(true);
				dextnj.download(request, response, target);
			} else {
				dextnj.download(request, response, target, target.getName(), "application/octet-stream", false, false);
			}
			
		} catch (Exception e) {
			throw new ServletException(e);
		}
	}
}
