package sample_x5_nj_servlet_ja;

import java.io.IOException;
import java.util.Optional;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@SuppressWarnings("serial")
public class AWSS3Download extends HttpServlet {

    public AWSS3Download() {
        super();
    }

	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		
		request.setCharacterEncoding("UTF-8");
		response.setCharacterEncoding("UTF-8");
		response.setContentType("application/json");
		
		try {
			
			String key = Optional.ofNullable(request.getParameter("key")).orElse("");
			
			if (!key.isEmpty()) {
				AWSS3DownloadHelper helper = new AWSS3DownloadHelper();
				response.getWriter().write(helper.getPresignedURL(key));
			} else {		
				response.setStatus(400);
				response.getWriter().write("{ \"error\": \"Invalid parameters.\" }");
			}
			
		} catch (Exception ex) {
			response.setStatus(500);
			response.getWriter().write(String.format("{ \"error\": \"%s\" }", ex.getMessage()));
		}
	}

}
