﻿<%@ language="VBScript" %>
<% option explicit %>
<!--#include file="cLibrary.asp"-->
<%
'UTF-8 코드 페이지 번호 및 문자셋 이름
const UTF8_CODEPAGE = 65001
const UTF8_CHARSET = "UTF-8"
'응답 데이터 타입
const CONTENT_TYPE_TEXTPLAIN = "text/plain"
'서버 오류
const HTTP_INTERNAL_SERVER_ERR = "500"
const HTTP_FILE_NOT_FOUND_ERR = "404"

on error resume next

sub Main()
	Session.CodePage = CStr(UTF8_CODEPAGE)
	Response.CharSet = UTF8_CHARSET
	Response.Clear()

	dim vindexes, tempFolder, defaultFolder, fs, compressor, i, file, compressedPath

    'DEXTUploadX5_VIndexes 폼 이름으로부터 압축할 대상의 가상 인덱스 집합을 얻을 수 있다.
	vindexes = Split(GetFormString("DEXTUploadX5_VIndexes", "", true), ",")
    '압축 파일을 생성할 폴더의 경로이다.
    tempFolder = Request.ServerVariables("APPL_PHYSICAL_PATH") & "files\temp\"
    '원본 파일이 있는 폴더의 경로이다.
	defaultFolder = Request.ServerVariables("APPL_PHYSICAL_PATH") & "files\attach\"

    set fs = Server.CreateObject("Scripting.FileSystemObject")
    '압축을 위한 DEXTProCompressor 객체를 생성한다.
    set compressor = Server.CreateObject("DEXT.DEXTProCompressor")
    '압축 레벨을 설정한다. zip 형식의 압축에서만 유효한다.
    '0~9 사이의 값을 사용한다. 미지정 시 기본 압축레벨(-1)이 사용된다.
    compressor.CompLevel = -1
	
    '압축할 대상을 DEXTProCompressor 객체에 추가를 한다.
    '압축 파일 이름은 객체에 가장 먼저 추가되는 파일 이름을 따르도록 한다.
    for i = 0 to ubound(vindexes)
	    '열려는 대상을 설정한다.
	    if vindexes(i) = "IDX0003" then
		    set file = fs.GetFile(defaultFolder & "서강대교_509147.jpg")
	    elseif vindexes(i) = "IDX0004" then
		    set file = fs.GetFile(defaultFolder & "우도해변_239826.jpg")
	    elseif vindexes(i) = "IDX0005" then
		    set file = fs.GetFile(defaultFolder & "코스모스 (빈공간) 195779.jpg")
	    else
		    set file = nothing
	    end if

        if not file is nothing then
            compressor.AddFile(file.Path)
            if compressor.Count = 1 then
                '압축파일 형식에 따라 생성 경로 설정
                'zip, 7z 두 개의 압축 형식을 지원한다.
                'zip, 7z 이외의 확장자 지정 시 zip 형식으로 처리 된다.
                compressor.CompFileSavePath = tempFolder & GetFileNameWithoutExtension(file.Name) & ".zip"
            end if
        end if

        set file = nothing       
    next

    if compressor.Count > 0 then
        '압축을 실행한다.
        compressedPath = compressor.Compress(true)

        set file = fs.GetFile(compressedPath)

	    Response.ContentType = CONTENT_TYPE_TEXTPLAIN
        Response.CharSet = UTF8_CHARSET
        Response.Clear()
        '예제가 아닌 실제 상황에서는 세션 또는 데이터베이스와 같은 다른 저장 방식을 이용하여
        '실제로 다운로드를 수행해야 하는 페이지(zip-download.asp)에서 압축 파일의 경로를 얻을 수 있도록 처리해야 한다.
        '그러나 예제에서는 압축 파일 이름을 쿼리스트링으로 하는 다운로드 주소를 응답 데이터에 기록하여 DEXTUploadX5가 받을 수 있도록 한다.
        Response.Write(GetProtocolFromURL() & "://" & GetDomainFromURL() & ":" & GetPortFromURL() & _
            "/service/zip-download.asp?name=" & Replace(Server.UrlEncode(file.Name), "+", "%20"))

        set file = nothing
    else
        Response.AppendToLog("Targets for zip not found")	
		Response.Status = HTTP_FILE_NOT_FOUND_ERR
    end if
    	
    set compressor = nothing
    set fs = nothing

	if Err.Number <> 0 then
		Response.AppendToLog(GetErrorMessage(Err))	
		Response.Status = HTTP_INTERNAL_SERVER_ERR
		Err.Clear()
	end if
end sub

'메인 실행
call Main()
%>