﻿namespace sample_x5_net5_mvc5_ko.Controllers
{
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Web;
    using System.Web.Mvc;

    public class AzureBlobStorageSampleController : Controller
    {
        public ActionResult Ex001() { return View(); }
        public ActionResult Ex002() { return View(); }

        [HttpPost]
        public ActionResult GetListSasToken(string key)
        {
            if (!string.IsNullOrEmpty(key))
            {
                var gen = new AzureSasTokenGenerator();
                // POST application/x-www-form-urlencoded 인코딩으로 전송된 경우 key는 인코딩된 상태이므로 디코딩이 필요하다.
                var sasToken = gen.GenerateListSasToken(HttpUtility.UrlDecode(key).Replace("%20", "+"));
                return Content(sasToken, "text/plain", Encoding.UTF8);
            }
            else
            {
                throw new HttpException(400, "Invalid parameters.");
            }
        }

        [HttpGet]
        public ActionResult GetUploadSasToken()
        {
            var gen = new AzureSasTokenGenerator();
            var sasToken = gen.GenerateContainerSasToken();
            return Content(sasToken, "text/plain", Encoding.UTF8);
        } 

        [HttpPost]
        public ActionResult GetDownloadSasToken(string key)
        {
            if (!string.IsNullOrEmpty(key))
            {
                var gen = new AzureSasTokenGenerator();
                // POST application/x-www-form-urlencoded 인코딩으로 전송된 경우 key는 인코딩된 상태이므로 디코딩이 필요하다.
                var sasToken = gen.GenerateBlobSasToken(HttpUtility.UrlDecode(key).Replace("%20", "+"));
                return Content(sasToken, "text/plain", Encoding.UTF8);
            }
            else
            {
                throw new HttpException(400, "Invalid parameters.");
            }
        }
    }
}