﻿namespace sample_x5_net5_mvc5_ko.Controllers
{
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Web;
    using System.Web.Mvc;
    using Amazon.S3.Model;

    public class AmazonS3SampleController : Controller
    {
        public ActionResult Ex001() { return View(); }
        public ActionResult Ex002() { return View(); }
        public ActionResult Ex003() { return View(); }
        public ActionResult Ex004() { return View(); }

        [HttpPost]
        public ActionResult InitUpload(string key, string acl = "private", string sclass = "STANDARD", string type = "", string metadata = "")
        {
            if (!string.IsNullOrEmpty(key) && !string.IsNullOrEmpty(type))
            {
                var helper = new AWSS3MultipartUploadHelper();
                var responseString = helper.InitializeUpload(key, sclass, acl, type, metadata);
                return Content(responseString, "application/json", Encoding.UTF8);
            }
            else
            {
                throw new HttpException(400, "{ \"error\": \"Invalid parameters.\" }");
            }
        }

        [HttpPost]
        public ActionResult GetPresignedUploadURL(string key, string uid, int pnum)
        {
            if (!string.IsNullOrEmpty(key) && !string.IsNullOrEmpty(uid))
            {
                var helper = new AWSS3MultipartUploadHelper();
                var responseString = helper.GetPresignedURL(key, uid, pnum);
                return Content(responseString, "application/json", Encoding.UTF8);
            }
            else
            {
                throw new HttpException(400, "{ \"error\": \"Invalid parameters.\" }");
            }
        }

        [HttpPost]
        public ActionResult CompleteUpload(string key, string uid, List<int> pnum, List<string> etag)
        {
            var zipped = pnum.Zip(etag, (ns, et) => new PartETag { PartNumber = ns, ETag = et });

            if (!string.IsNullOrEmpty(key) && !string.IsNullOrEmpty(uid) && zipped.Count() > 0)
            {
                var helper = new AWSS3MultipartUploadHelper();
                var responseString = helper.CompleteUpload(key, uid, zipped.ToList());
                return Content(responseString, "application/json", Encoding.UTF8);
            }
            else
            {
                throw new HttpException(400, "{ \"error\": \"Invalid parameters.\" }");
            }
        }

        [HttpPost]
        public ActionResult AbortUpload(string key, string uid)
        {
            if (!string.IsNullOrEmpty(key) && !string.IsNullOrEmpty(uid))
            {
                var helper = new AWSS3MultipartUploadHelper();
                helper.AbortUpload(key, uid);
                return Content(string.Empty, "text/plain", Encoding.UTF8);
            }
            else
            {
                throw new HttpException(400, "{ \"error\": \"Invalid parameters.\" }");
            }
        }

        [HttpPost]
        public ActionResult GetPresignedDownloadURL(string key)
        {
            if (!string.IsNullOrEmpty(key))
            {
                var helper = new AWSS3DownloadHelper();
                var responseString = helper.GetPresignedURL(key);
                return Content(string.Format("{{ \"url\": \"{0}\" }}", responseString), "application/json", Encoding.UTF8);
            }
            else
            {
                throw new HttpException(400, "{ \"error\": \"Invalid parameters.\" }");
            }
        }
    }
}