﻿namespace sample_x5_net5_mvc5_ko
{
	using System;
	using Azure.Storage;
	using Azure.Storage.Sas;

	public class AzureSasTokenGenerator
	{
		public const string ACCOUNT_NAME = "";
		public const string CONTAINER_NAME = "";
		// 컨테이너의 액세스키
		public const string ACCOUNT_KEY = "";

		public AzureSasTokenGenerator()
		{
		}

		public string GenerateListSasToken(string blobName)
		{
			var credential = new StorageSharedKeyCredential(ACCOUNT_NAME, ACCOUNT_KEY);
			var sasBuilder = new BlobSasBuilder
			{
				BlobContainerName = CONTAINER_NAME,
				// 인코딩되지 않은 이름으로 공유액세스 토큰을 만들어야 한다.
				BlobName = blobName,
				// 리소스 범위를 Blob으로 설정한다.
				Resource = "b",
				// 서버 간 시간 차가 있기 때문에 시작 시간을 5분 정도 일찍 설정한다.
				StartsOn = DateTimeOffset.UtcNow.AddMinutes(-5),
				// 1시간 유효
				ExpiresOn = DateTimeOffset.UtcNow.AddMinutes(60)
			};
			// 커밋되지 않은 블록 목록을 읽기 위한 공유액세스 토큰은 Read, List 권한이 필요하다.
			sasBuilder.SetPermissions(BlobAccountSasPermissions.Read | BlobAccountSasPermissions.List);

			var sasToken = sasBuilder.ToSasQueryParameters(credential);

			return sasToken.ToString();
		}

		public string GenerateContainerSasToken()
		{
			var credential = new StorageSharedKeyCredential(ACCOUNT_NAME, ACCOUNT_KEY);
			var sasBuilder = new BlobSasBuilder
			{
				BlobContainerName = CONTAINER_NAME,
				// 리소스 범위를 컨테이너로 설정한다.
				Resource = "c",
				// 서버 간 시간 차가 있기 때문에 시작 시간을 5분 정도 일찍 설정한다.
				StartsOn = DateTimeOffset.UtcNow.AddMinutes(-5),
				// 1시간 유효
				ExpiresOn = DateTimeOffset.UtcNow.AddMinutes(60)
			};

			// 파일을 업로드하기 위한 공유액세스 토큰은 Create, Write 권한이 필요하다.
			sasBuilder.SetPermissions(BlobAccountSasPermissions.Write | BlobAccountSasPermissions.Create);

			var sasToken = sasBuilder.ToSasQueryParameters(credential);

			return sasToken.ToString();
		}

		public string GenerateBlobSasToken(string blobName)
		{
			var credential = new StorageSharedKeyCredential(ACCOUNT_NAME, ACCOUNT_KEY);
			var sasBuilder = new BlobSasBuilder
			{
				BlobContainerName = CONTAINER_NAME,
				// 인코딩되지 않은 이름으로 공유액세스 토큰을 만들어야 한다.
				BlobName = blobName,
				// 리소스 범위를 Blob으로 설정한다.
				Resource = "b",
				// 서버 간 시간 차가 있기 때문에 시작 시간을 5분 정도 일찍 설정한다.
				StartsOn = DateTimeOffset.UtcNow.AddMinutes(-5),
				// 1시간 유효
				ExpiresOn = DateTimeOffset.UtcNow.AddMinutes(60)
			};

			sasBuilder.SetPermissions(BlobAccountSasPermissions.Read);

			var sasToken = sasBuilder.ToSasQueryParameters(credential);

			return sasToken.ToString();
		}
	}
}